using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Phidgets;
using Phidgets.Events;


namespace TextLCD_Controller
{
    public partial class Form1 : Form
    {
        TextLCD lcd;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            lcd = new TextLCD();
            lcd.Attach += new AttachEventHandler(lcd_Attach);
            lcd.Detach += new DetachEventHandler(lcd_Detach);
            lcd.open();
        }

        void lcd_Detach(object sender, DetachEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new DetachEventHandler(lcd_Detach),
                            new object[] { sender, e });
            else
            {
                attachedLabel.Text = "Not Attached";
            }
        }

        void lcd_Attach(object sender, AttachEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new AttachEventHandler(lcd_Attach),
                            new object[] { sender, e });
            else
            {
                Phidgets.TextLCD phid = (Phidgets.TextLCD)sender;
                attachedLabel.Text = "Attached: " + phid.Name;
                serialLabel.Text = " Serial: " + phid.SerialNumber;
                versionLabel.Text = " Version: " + phid.Version;

                backightCheckBox.Checked = lcd.Backlight;
                cursorCheckBox.Checked = lcd.Cursor;
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            TextBox box = (TextBox)sender;
            lcd.rows[0].DisplayString = box.Text;
        }

        private void textBox2_TextChanged(object sender, EventArgs e)
        {
            TextBox box = (TextBox)sender;
            lcd.rows[1].DisplayString = box.Text;
        }

        private void backightCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            lcd.Backlight = backightCheckBox.Checked;
        }

        private void cursorCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            lcd.Cursor = cursorCheckBox.Checked;
        }

        private void contrastTrackbar_Scroll(object sender, EventArgs e)
        {
            lcd.Contrast = contrastTrackbar.Value;
        }

        private void blinkCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            lcd.CursorBlink = blinkCheckBox.Checked;
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            lcd.rows[0].DisplayString = "Testing Custom Chars";
            lcd.customCharacters[0].setCustomCharacter(0x0, 0xF8000);
            lcd.customCharacters[1].setCustomCharacter(0x0, 0xFFC00);
            lcd.customCharacters[2].setCustomCharacter(0x0, 0xFFFE0);
            lcd.customCharacters[3].setCustomCharacter(0x0, 0xFFFFF);
            lcd.customCharacters[4].setCustomCharacter(0xF8000, 0xFFFFF);
            lcd.customCharacters[5].setCustomCharacter(0xFFC00, 0xFFFFF);
            lcd.customCharacters[6].setCustomCharacter(0xFFFE0, 0xFFFFF);
            lcd.customCharacters[7].setCustomCharacter(0xFFFFF, 0xFFFFF);
            //raw hex codes
            //lcd.rows[1].DisplayString = "\u0008\u0009\u000a\u000b\u000c\u000d\u000e\u000f";
            //API access to codes
            lcd.rows[1].DisplayString = lcd.customCharacters[0].StringCode +
                lcd.customCharacters[1].StringCode +
                lcd.customCharacters[2].StringCode +
                lcd.customCharacters[3].StringCode +
                lcd.customCharacters[4].StringCode +
                lcd.customCharacters[5].StringCode +
                lcd.customCharacters[6].StringCode +
                lcd.customCharacters[7].StringCode;
            //Entering a custom characer within your string
            //lcd.rows[1].DisplayString = "Hel" + lcd.customCharacters[3].StringCode + "lo";
        }
    }
}